% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclust_single.R
\name{hclust_single}
\alias{hclust_single}
\title{Hierarchical Clustering - Single linkage}
\usage{
hclust_single(
  data,
  metric = "euclidean",
  print.steps = TRUE,
  plot = TRUE,
  label.names = TRUE
)
}
\arguments{
\item{data}{Numerical matrix or data frame of observations (rows = observations, columns = variables).}

\item{metric}{Distance metric to be used (default: "euclidean").}

\item{print.steps}{If TRUE, the algorithm's steps are printed.}

\item{plot}{If TRUE, a dendrogram is plotted.}

\item{label.names}{If TRUE, uses the row names as labels in the dendrogram.}
}
\value{
object of class "hclust".
}
\description{
A function that performs hierarchical clustering with single linkage.
It can also print the clustering steps and display a dendrogram
}
\examples{
y1 <- c(1, 2, 1, 0); y2 <- c(2, 1, 0, 2)
y3 <- c(8, 8, 9, 7); y4 <- c(6, 9, 8, 9)
Data <- rbind(y1, y2, y3, y4)
hc <- hclust_single(Data, metric = "euclidean",
                    print.steps = TRUE,
                    plot = TRUE,
                    label.names = TRUE)
}
