% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbsae.R
\name{fSAE.Area}
\alias{fSAE.Area}
\title{Compute small area estimates based on the basic area-level model.}
\usage{
fSAE.Area(est.init, var.init, X, x, ...)
}
\arguments{
\item{est.init}{m-vector of initial estimates, where m is the number of in-sample areas.}

\item{var.init}{m-vector of corresponding variance estimates.}

\item{X}{M x p matrix of area-level covariates (typically population means), where M is the number of areas for which estimates are computed.
If missing, a column vector of ones of the same length as \code{est.init} is used, corresponding to a model with an intercept only.
The M areas may or may not equal the m areas for which initial estimates are provided. For example, estimates
for out-of-sample areas, for which no initial estimates are available, are computed as long as the corresponding
rows of auxiliary means are in \code{X}. It is also possible to compute estimates only for a subset of sample areas,
see the help for argument \code{x}.}

\item{x}{an optional m x p matrix with auxiliary area-level covariates to be used for fitting the model,
where the rows correspond to the components of \code{est.init}.
If the M areas corresponding to the rows of \code{X} do not contain all m areas corresponding to
\code{est.init}, \code{x} must be provided separately in order to be able to fit the model.}

\item{...}{additional arguments passed to \code{\link{fSAE.Unit}}. For example, passing
an M-vector \code{Narea} with area population sizes (along with the matrix \code{X} of
population means) allows to compute aggregates of the small area estimates. See the
documentation of function \code{\link{fSAE.Unit}} for a description of other possible arguments.}
}
\value{
An object of class \code{sae} containing the small area estimates and MSEs, the model fit, and model selection measures.
}
\description{
This function returns small area estimates based on the basic area-level model, also known as the Fay-Herriot model.
It calls \code{\link{fSAE.Unit}} to carry out the computations.
}
\examples{
d <- generateFakeData()

# first compute input estimates without "borrowing strength" over areas
sae0 <- fSAE(y0 ~ x + area2, data=d$sam, area="area", popdata=d$Xpop,
             type="direct", keep.data=TRUE)

# compute small area estimates based on the basic area-level model
#   using the above survey regression estimates as input
sae <- fSAE.Area(EST(sae0), MSE(sae0), X=sae0$Xp)
EST(sae)  # estimates
RMSE(sae)  # standard errors
}
\references{
R.E. Fay and R.A. Herriot (1979). Estimates of Income for Small Places: An Application of James-Stein Procedures to Census Data.
  Journal of the American Statistical Association 74(366), 269-277.

  J.N.K. Rao and I. Molina (2015). Small Area Estimation. Wiley.
}
\seealso{
\code{\link{sae-class}}
}
