% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_rtad.R
\name{hanr_rtad}
\alias{hanr_rtad}
\title{Anomaly and change point detector using RTAD}
\usage{
hanr_rtad(sw_size = 30, noise = 0.001, trials = 5, sigma = sd)
}
\arguments{
\item{sw_size}{sliding window size (default 30)}

\item{noise}{noise}

\item{trials}{trials}

\item{sigma}{function to compute the dispersion}
}
\value{
\code{hanr_rtad} object
}
\description{
Anomaly and change point detection using RTAD
The RTAD model adjusts to the time series. Observations distant from the model are labeled as anomalies.
It wraps the EMD model presented in the hht library.
}
\examples{
library(daltoolbox)
library(zoo)

# Load anomaly example data
data(examples_anomalies)

# Use a simple example
dataset <- examples_anomalies$simple
head(dataset)

# Configure RTAD detector
model <- hanr_rtad()

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected events
print(detection[(detection$event),])

}
\references{
\itemize{
\item Ogasawara, E., Salles, R., Porto, F., Pacitti, E. Event Detection in Time Series. 1st ed.
Cham: Springer Nature Switzerland, 2025. doi:10.1007/978-3-031-75941-3
}
}
