% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_basis.R
\name{basis_of_degree}
\alias{basis_of_degree}
\title{Compute Degree of Basis Functions}
\usage{
basis_of_degree(
  x,
  degree,
  smoothness_orders,
  include_zero_order,
  include_lower_order
)
}
\arguments{
\item{x}{An input \code{matrix} containing observations and covariates
following standard conventions in problems of statistical learning.}

\item{degree}{The highest order of interaction terms for which the basis
functions ought to be generated. The default (\code{NULL}) corresponds to
generating basis functions for the full dimensionality of the input matrix.}

\item{smoothness_orders}{An integer vector of length \code{ncol(x)}
specifying the desired smoothness of the function in each covariate. k = 0
is no smoothness (indicator basis), k = 1 is first order smoothness, and so
on. For an additive model, the component function for each covariate will
have the degree of smoothness as specified by smoothness_orders. For
non-additive components (tensor products of univariate basis functions),
the univariate basis functions in each tensor product have smoothness
degree as specified by smoothness_orders.}

\item{include_zero_order}{A \code{logical}, indicating whether the zeroth
order basis functions are included for each covariate (if \code{TRUE}), in
addition to the smooth basis functions given by \code{smoothness_orders}.
This allows the algorithm to data-adaptively choose the appropriate degree
of smoothness.}

\item{include_lower_order}{A \code{logical}, like \code{include_zero_order},
except including all basis functions of lower smoothness degrees than
specified via \code{smoothness_orders}.}
}
\value{
A \code{list} containing  basis functions and cutoffs generated from
a set of input columns up to a particular pre-specified degree.
}
\description{
Find the full list of basis functions up to a particular degree
}
