% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_split.R
\name{tbl_split_by}
\alias{tbl_split_by}
\alias{tbl_split_by_rows}
\alias{tbl_split_by_columns}
\alias{print.tbl_split}
\title{Split gtsummary table by rows and/or columns}
\usage{
tbl_split_by_rows(
  x,
  variables = NULL,
  row_numbers = NULL,
  variable_level = NULL,
  footnotes = c("all", "first", "last"),
  caption = c("all", "first", "last")
)

tbl_split_by_columns(
  x,
  keys,
  groups,
  footnotes = c("all", "first", "last"),
  caption = c("all", "first", "last")
)

\method{print}{tbl_split}(x, ...)
}
\arguments{
\item{x}{(\code{gtsummary} or \code{list})\cr
gtsummary table.}

\item{variables, row_numbers, variable_level}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}} or \code{integer})\cr
Specifies where the table will be split.
\itemize{
\item \code{variables}: Tables will be separated after each of the variables specified.
The \code{x$table_body} data frame must contains a \code{'variable'}
column to use this argument.
\item \code{row_numbers}: Row numbers after which the table will be split.
\item \code{variable_level}: A single column name in \code{x$table_body}. When specified,
the table will be split at each unique level of the
variable.
}}

\item{footnotes, caption}{(\code{string}) \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr
can be either \code{"first"}, \code{"all"}, or \code{"last"}, to locate global footnotes or
caption only on the first, in each, or in the last table, respectively. It defaults
to \code{"all"}. Reference footnotes are always present wherever they appear.}

\item{keys}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to be repeated in each table split. It defaults to the first column
if missing (usually label column).}

\item{groups}{(list of \code{character} vectors)\cr
list of column names that appear in \code{x$table_body}.
Each group of column names represent a different table in the output list.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
\code{tbl_split} object. If multiple splits are performed (e.g., both by
row and columns), the output is returned a single level list.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr
The \code{tbl_split_by_rows()} and \code{tbl_split_by_columns()} functions split a single
gtsummary table into multiple tables.
Both column-wise splitting (that is, splits by columns in
\code{x$table_body}) and row-wise splitting is possible.
}
\details{
Run \code{\link[=show_header_names]{show_header_names()}} to print all column names to split by.

Footnotes and caption handling are experimental and may change in the future.

\code{row_numbers} indicates the row numbers at which to split the table. It means
that the table will be split after each of these row numbers. If the last
row is selected, the split will not happen as it is supposed to happen after
the last row.
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) withAutoprint(\{ # examplesIf}
# Example 1 ----------------------------------
# Split by rows
trial |>
  tbl_summary(by = trt) |>
  tbl_split_by_rows(variables = c(marker, grade)) |>
  dplyr::last() # Print only last table for simplicity

# Example 2 ----------------------------------
# Split by rows with row numbers
trial |>
  tbl_summary(by = trt) |>
  tbl_split_by_rows(row_numbers = c(5, 7)) |>
  dplyr::last() # Print only last table for simplicity

# Example 3 ----------------------------------
# Split by columns
trial |>
  tbl_summary(by = trt, include = c(death, ttdeath)) |>
  tbl_split_by_columns(groups = list("stat_1", "stat_2")) |>
  dplyr::last() # Print only last table for simplicity

# Example 4 ----------------------------------
# Both row and column splitting
trial |>
  tbl_summary(by = trt) |>
  tbl_split_by_rows(variables = c(marker, grade)) |>
  tbl_split_by_columns(groups = list("stat_1", "stat_2")) |>
  dplyr::last() # Print only last table for simplicity

# Example 5 ------------------------------
# Split by rows with footnotes and caption
trial |>
  tbl_summary(by = trt, missing = "no") |>
  modify_footnote_header(
    footnote = "All but four subjects received both treatments in a crossover design",
    columns = all_stat_cols(),
    replace = FALSE
  ) |>
  modify_footnote_body(
    footnote = "Tumor grade was assessed _before_ treatment began",
    columns = "label",
    rows = variable == "grade" & row_type == "label"
  ) |>
  modify_spanning_header(
    c(stat_1, stat_2) ~ "**TRT**"
  ) |>
  modify_abbreviation("I = 1, II = 2, III = 3") |>
  modify_caption("_Some caption_") |>
  modify_footnote_spanning_header(
    footnote = "Treatment",
    columns = c(stat_1)
  ) |>
  modify_source_note("Some source note!") |>
  tbl_split_by_rows(variables = c(marker, stage, grade), footnotes = "last", caption = "first") |>
  dplyr::nth(n = 2) # Print only one but not last table for simplicity
\dontshow{\}) # examplesIf}
}
