% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_brazil_cetesb.R
\name{ef_brazil_cetesb}
\alias{ef_brazil_cetesb}
\title{Running exhaust emissions factors for buses from Brazil (CETESB)}
\usage{
ef_brazil_cetesb(pollutant, veh_type, model_year, as_list = TRUE)
}
\arguments{
\item{pollutant}{character. Pollutants "CH4", "CO2", "PM10", "N2O", "NOx",
"NO2", "NO", "RCHO", "ETOH" "KML" (Vehicle Kilometers Traveled), "FC" (Fuel Consumption),
"gD/KWH" (grams of Diesel per kWh), "gCO2/KWH" (grams of CO2 per per kWh),
"CO", "HC" (Total Hydrocarbon), "NMHC" (Non-Methane Hydrocarbon),
"FS"(Fuel Sales) and "NH3".}

\item{veh_type}{character. Vehicle categories by fuel: "BUS_URBAN_D",
"BUS_MICRO_D", "BUS_COACH_D" and "BUS_ARTIC_D".}

\item{model_year}{numeric. Vehicle model year. Supports \code{model_year} from
1960 to 2020.}

\item{as_list}{logical. If \code{TRUE} (default), the function returns the output
in a \code{list} format. If \code{FALSE}, the output is returned in a \code{data.table}
format.}
}
\value{
data.table. Emission factors in units 'g/km' by model_year.
}
\description{
Returns a vector or \code{data.table} of emission factors for buses based on
estimates from the  Environment Company of Sao Paulo, Brazil (CETESB) 2019.
Emission factor estimates are expressed in units 'g/km'.
}
\details{
The new convention for vehicles names are translated from CETESB report:\tabular{ll}{
   vehicle \tab description \cr
   BUS_URBAN_D \tab Urban Bus Diesel (5perc bio-diesel) \cr
   BUS_MICRO_D \tab Micro Urban Bus Diesel (5perc bio-diesel) \cr
   BUS_COACH_D \tab Coach (inter-state) Bus Diesel (5perc bio-diesel) \cr
   BUS_ARTIC_D \tab Articulated Urban Bus Diesel (5perc bio-diesel) \cr
}


The percentage varies of biofuels varies by law.

These emission factors are not exactly the same as the report of CETESB.
\enumerate{
\item In this emission factors, there is also NO and NO2 based on split by published in the EMEP/EEA
air pollutant emission inventory guidebook.
\item Also, the emission factors were extended till 50 years of use, repeating the oldest value.
}
}
\examples{
df <- ef_brazil_cetesb(
          pollutant = c("CO","PM10","CO2","CH4","NOx"),
          veh_type = "BUS_URBAN_D",
          model_year = 2015,
          as_list = TRUE)

}
\seealso{
Other Emission factor model: 
\code{\link{ef_europe_emep}()},
\code{\link{ef_scaled_euro}()},
\code{\link{ef_usa_emfac}()},
\code{\link{ef_usa_moves}()},
\code{\link{emi_europe_emep_wear}()}
}
\concept{Emission factor model}
