% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_css}
\alias{opt_css}
\title{Option to add custom CSS for the table}
\usage{
opt_css(data, css, add = TRUE, allow_duplicates = FALSE)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{css}{\emph{CSS declarations}

\verb{scalar<character>} // \strong{required}

The CSS to include as part of the rendered table's \verb{<style>} element.}

\item{add}{\emph{Add to existing CSS}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

If \code{TRUE}, the default, the CSS is added to any already-defined CSS
(typically from previous calls of \code{\link[=opt_table_font]{opt_table_font()}}, \code{opt_css()}, or,
directly setting CSS the \code{table.additional_css} value in \code{\link[=tab_options]{tab_options()}}).
If this is set to \code{FALSE}, the CSS provided here will replace any
previously-stored CSS.}

\item{allow_duplicates}{\emph{Allow for CSS duplication}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

When this is \code{FALSE} (the default), the CSS provided here won't be added
(provided that \code{add = TRUE}) if it is seen in the already-defined CSS.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
\code{opt_css()} makes it possible to add CSS to a \strong{gt} table. This  CSS will be
added after the compiled CSS that \strong{gt} generates automatically when the
object is transformed to an HTML output table. You can supply \code{css} as a
vector of lines or as a single string.
}
\section{Examples}{


Let's use the \code{\link{exibble}} dataset to create a simple, two-column \strong{gt} table
(keeping only the \code{num} and \code{currency} columns). Through use of the
\code{opt_css()} function, we can insert CSS rulesets as as string. We need to
ensure that the table ID is set explicitly (we've done so here with the
ID value of \code{"one"}, setting it in the \code{\link[=gt]{gt()}} function).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  dplyr::select(num, currency) |>
  gt(id = "one") |>
  fmt_currency(
    columns = currency,
    currency = "HKD"
  ) |>
  fmt_scientific(columns = num) |>
  opt_css(
    css = "
    #one .gt_table \{
      background-color: skyblue;
    \}
    #one .gt_row \{
      padding: 20px 30px;
    \}
    #one .gt_col_heading \{
      text-align: center !important;
    \}
    "
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_opt_css_1.png" alt="This image of a table was generated from the first code example in the `opt_css()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

10-14
}

\section{Function Introduced}{

\code{v0.2.2} (August 5, 2020)
}

\seealso{
Other table option functions: 
\code{\link{opt_align_table_header}()},
\code{\link{opt_all_caps}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_footnote_order}()},
\code{\link{opt_footnote_spec}()},
\code{\link{opt_horizontal_padding}()},
\code{\link{opt_interactive}()},
\code{\link{opt_row_striping}()},
\code{\link{opt_stylize}()},
\code{\link{opt_table_font}()},
\code{\link{opt_table_lines}()},
\code{\link{opt_table_outline}()},
\code{\link{opt_vertical_padding}()}
}
\concept{table option functions}
