% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt2tau.R
\name{gt2tau}
\alias{gt2tau}
\alias{gt2tauAP}
\alias{gt2power}
\alias{gt2minor}
\alias{gt2major}
\alias{gt2asens}
\alias{gt2rsens}
\alias{gt2rmse}
\title{Map GT-based Indicators onto Data-based Indicators}
\usage{
gt2tau(Erho2)

gt2tauAP(Erho2)

gt2power(Erho2)

gt2minor(Erho2)

gt2major(Erho2)

gt2asens(Erho2)

gt2rsens(Phi)

gt2rmse(Phi)
}
\arguments{
\item{Erho2}{Vector of generalizability coefficients to map from.}

\item{Phi}{Vector of indices of dependability to map from.}
}
\value{
A vector of data-based indicator values.
}
\description{
Maps Erho2 and Phi scores from Generalizability Theory onto traditional data-based scores like
the Kendall tau correlation, AP correlation, power, minor conflict rate and major conflict rate
with 2-tailed t-tests, absolute and relative sensitivity, and rooted mean squared error.
}
\details{
Take these mappings with a grain of salt. See figure 3 in (Urbano, 20013).
}
\examples{
g <- gstudy(adhoc3)
d <- dstudy(g)
gt2tau(d$Erho2)
gt2rmse(d$Phi)

}
\references{
J. Urbano, M. Marrero and D. Martín (2013). On the Measurement of Test Collection
  Reliability. ACM SIGIR, pp. 393-402.
}
\seealso{
\code{\link{dstudy}}
}
\author{
Julián Urbano
}
