% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter2.R
\name{filter2}
\alias{filter2}
\title{2-D digital filter}
\usage{
filter2(h, x, shape = c("same", "full", "valid"))
}
\arguments{
\item{h}{transfer function, specified as a matrix.}

\item{x}{numeric matrix containing the input signal to be filtered.}

\item{shape}{Subsection of convolution, partially matched to:
\describe{
  \item{"same"}{Return the central part of the filtered data; same size as
  \code{x} (Default)}
  \item{"full"}{Return the full 2-D filtered data, with zero-padding on all
  sides before filtering}
  \item{"valid"}{Return only the parts which do not include zero-padded
  edges.}
}}
}
\value{
The filtered signal, returned as a matrix
}
\description{
Apply a 2-D digital filter to the data in \code{x}.
}
\details{
The \code{filter2} function filters data by taking the 2-D convolution of the
input \code{x} and the coefficient matrix \code{h} rotated 180 degrees. More
specifically, \code{filter2(h, x, shape)} is equivalent to \code{conv2(x,
rot90(h, 2), shape)}.
}
\examples{
op <- par(mfcol = c(1, 2))
x <- seq(-10, 10, length.out = 30)
y <- x
f <- function(x, y) { r <- sqrt(x^2+y^2); 10 * sin(r)/r }
z <- outer(x, y, f)
z[is.na(z)] <- 1
persp(x, y, z, theta = 30, phi = 30, expand = 0.5, col = "lightblue")
title( main = "Original")

h <- matrix(c(1, -2, 1, -2, 3, -2, 1, -2, 1), 3, 3)
zf <-filter2(h, z, 'same')
persp(x, y, zf, theta = 30, phi = 30, expand = 0.5, col = "lightgreen")
title( main = "Filtered")
par(op)

}
\seealso{
\code{\link{conv2}}
}
\author{
Paul Kienzle.
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
