% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_functions.R
\name{get_recruittimes}
\alias{get_recruittimes}
\title{get_recruittimes}
\usage{
get_recruittimes(accrual_period, n, accrual_exponent)
}
\arguments{
\item{accrual_period}{numeric; duration of accrual period. Must be positive.}

\item{n}{numeric; number of subjects recruited at end of accrual period.}

\item{accrual_exponent}{numeric; exponent in sample size function \eqn{f(t)}.}
}
\description{
Calculate the times subjects enter the study
}
\details{
Number of subjects in the study at study time t is given by
f(t)=a * t^b with  a = n / accrual_period.
For linear recruitment, b=1. 
b > 1 results is slower than linear recruitment for t < accrual_period and 
faster than linear recruitment for t > accrual_period. b < 1 vice versa.
}
\keyword{internal}
