% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DWT.R
\name{DWT}
\alias{DWT}
\title{Discrete wavelet transform}
\usage{
DWT(data, filter.number = 10, family = "DaubLeAsymm")
}
\arguments{
\item{data}{A matrix of data, where each row is an observation.
The number of columns must be a power of two.}

\item{filter.number}{The smoothness of the wavelet to use in the
decomposition.}

\item{family}{The family of wavelets. The two most common options
are \code{DaubExPhase} and \code{DaubLeAsymm}.}
}
\value{
A \code{DWT} object. This object is a list with the following
components:
}
\description{
This function performs the discrete wavelet transform (DWT) according to
Mallat's pyramidal algorithm (Mallat, 1989).
}
\details{
See function \code{wd} from package \code{wavethresh} for more details.
}
\examples{
data <- GenerateSyntheticAnova(st.dev = 5, n.replicates = 10)
W <- DWT(data$noisy.Y)
}

