% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_szgaGAw.R
\name{szgaGAw}
\alias{szgaGAw}
\title{Sample size optimization using graphical approach in clinical trial design with three hypotheses when the transition matrix is pre-specified}
\usage{
szgaGAw(
  alpha,
  betaVec,
  deltaVec,
  cVec,
  rhoMat,
  transMat,
  lower = c(1, rep(1e-06, 2)),
  upper = c(10000, rep(1 - 1e-06, 2)),
  gaIter = c(20, 20),
  penPara = 0.1,
  seed = 2022
)
}
\arguments{
\item{alpha}{a value of overall type I error rate}

\item{betaVec}{a vector of one minus marginal powers for testing H1, H2 and H3, respectively}

\item{deltaVec}{a vector of effect sizes for testing H1, H2 and H3, respectively}

\item{cVec}{a vector of coefficients. When testing continuous endpoints, these coefficients are exactly one. When testing binary endpoints, the values are roughly one but not exactly one}

\item{rhoMat}{a matrix of the correlation coefficients among three hypotheses}

\item{transMat}{a matrix of the fixed transition probabilities among three hypotheses}

\item{lower}{a vector of lower limit of sample size n, and initial weights w1 and w2, where w3 is computed by 1 - w1 - w2}

\item{upper}{a vector of upper limit of sample size n, and initial weights w1 and w2, where w3 is computed by 1 - w1 - w2}

\item{gaIter}{a vector of two numbers. The first one is the parameter maxiter of the ga function, and the second one is the parameter run of the ga function}

\item{penPara}{a number of penalization parameter for optimization to balance the sample size requirement and the power requirement}

\item{seed}{a number of the seed of the random number generator}
}
\value{
a vector of three numbers: the optimal sample size \code{n}, and initial weights \code{w1} and \code{w2}
}
\description{
This function computes the optimal design using graphical approach along with the minimum sample size when three hypotheses are considered in a clinical trial. The transition matrix is pre-specified and fixed.
}
\details{
R package \code{GA} is used for Genetic Algorithms.
}
\examples{
start <- Sys.time()
szgaGAw(alpha = 0.025, betaVec = c(0.15, 0.20, 0.10),
        deltaVec = c(0.1111952, 0.1037179, 0.1335865),
        cVec = c(1.003086, 1.002686, 1.004451),
        rhoMat = matrix(c(1,0.5,0.8, 0.5,1,0.6, 0.8,0.6,1), nrow = 3, byrow = TRUE),
        transMat = matrix(c(0,0.50,0.50, 0.5,0,0.5, 0.5,0.5,0), nrow = 3, byrow = TRUE),
        lower = c(700, rep(0.05, 2)),
        upper = c(900, rep(0.95, 2)),
        gaIter = c(10, 5),
        penPara = 0.0135,
        seed = 234)
end <- Sys.time()
data.frame(time = end - start)

}
\references{
Zhang, F. and Gou, J. (2023). Sample size optimization for clinical trials using graphical approaches for multiplicity adjustment, Technical Report.
Gou, J. (2022). Sample size optimization and initial allocation of the significance levels in group sequential trials with multiple endpoints. \emph{Biometrical Journal}, 64(2), 301-311.
}
\author{
Jiangtao Gou
}
