% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{ReadGRAND3}
\alias{ReadGRAND3}
\title{Read the output of GRAND-SLAM 3.0 into a grandR object.}
\usage{
ReadGRAND3(
  prefix,
  pseudobulk.name = NULL,
  targets.name = "targets",
  design = NULL,
  label = "4sU",
  estimator = "Binom",
  classify.genes = ClassifyGenes(),
  read.posterior = NULL,
  rename.sample = NULL,
  verbose = FALSE
)
}
\arguments{
\item{prefix}{the prefix used to call GRAND-SLAM}

\item{pseudobulk.name}{the pseudobulkName used to call GRAND-SLAM}

\item{targets.name}{the targetsName used to call GRAND-SLAM}

\item{design}{Either a design vector (see details), or a data.frame providing metadata for all columns (samples/cells),
or a function that is called with the condition name vector and is supposed to return this data.frame. if NULL, a
library,sample,barcode design is used for sparse data, and a condition,replicate design for dense data}

\item{label}{which nucleoside analog}

\item{estimator}{which estimator to use (one of Binom,TbBinom,TbBinomShape)}

\item{classify.genes}{A function that is used to add the \emph{type} column to the gene annotation table, always a call to \link{ClassifyGenes}}

\item{read.posterior}{also read the posterior parameters alpha and beta? if NULL, TRUE for dense data, FALSE for sparse data}

\item{rename.sample}{function that is applied to each sample name before parsing (or NULL; use the \link{Renamer} function)}

\item{verbose}{Print status updates}
}
\value{
A grandR object containing the read counts, NTRs, information on the NTR posterior distribution (alpha,beta)
and potentially additional information of all genes detected by GRAND-SLAM
}
\description{
Metabolic labeling - nucleotide conversion RNA-seq data (such as generated by SLAM-seq,TimeLapse-seq or TUC-seq)
must be carefully analyzed to remove bias due to incomplete labeling. GRAND-SLAM is a software package that
employs a binomial mixture modeling approach to obtain precise estimates of the new-to-total RNA ratio (NTR) per gene and sample (or cell).
This function directly reads the output of GRAND-SLAM 3.0 into a grandR object.
}
\details{
If columns (samples/cells) are named systematically in a particular way, the design vector provides
a powerful and easy way to create the column annotations.

The column names have to contain dots (.) to separate the fields for the column annotation table.
E.g. the name \emph{Mock.4h.A} will be split into the fields \emph{Mock}, \emph{4h} and  \emph{A}.
For such names, a design vector of length 3 has to be given, that describes the meaning of each field.
A reasonable design vector for the example would be \code{c("Treatment","Time","Replicate")}.
Some names are predefined in the list \link{Design}.

The names given in the design vector might even have additional semantics:
E.g. for the name \emph{duration.4sU} the values are interpreted (e.g. 4h is converted into the number 4,
or 30min into 0.5, or no4sU into 0). Semantics can be user-defined by calling \code{\link{MakeColdata}}
and using the return value as the design parameter, or a function that calls MakeColdata.
In most cases it is easier to manipulate the \code{\link{Coldata}} table after loading data instead of using this mechanism;
the build-in semantics simply provide a convenient way to reduce this kind of manipulation in most cases.

Sometimes you might have forgotten to name all samples consistently (or you simply messed something up).
In this case, the rename.sample parameter can be handy (e.g. to rename a particular misnamed sample).
}
\seealso{
\link{ReadGRAND},\link{ClassifyGenes},\link{MakeColdata},\link{DesignSemantics},\link{Renamer}
}
\concept{load}
