% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{use_nonconda}
\alias{use_nonconda}
\title{Set up grafzahl to be used on Google Colab or similar environments}
\usage{
use_nonconda(install = TRUE, check = TRUE, verbose = TRUE)
}
\arguments{
\item{install}{logical, whether to install the required Python packages}

\item{check}{logical, whether to perform a check after the setup. The check displays 1) whether CUDA can be detected, 2) whether
the non-conda mode has been activated, i.e. whether the option 'grafzahl.nonconda' is \code{TRUE}.}

\item{verbose, }{logical, whether to display messages}
}
\value{
TRUE (invisibly) if installation is successful.
}
\description{
Set up grafzahl to be used on Google Colab or similar environments. This function is also useful if you do not
want to use conda on a local machine, e.g. you have configurateed the required Python package.
}
\examples{
# A typical use case for Google Colab
if (interactive()) {
    use_nonconda()
}
}
