% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_plans.R
\name{compare_plans}
\alias{compare_plans}
\title{Probability of detection or non detection  versus fraction nonconforming curve}
\usage{
compare_plans(d, N, plim, type, c1, r1, t1, method1, c2, r2, t2, method2,
                     c3, r3, t3, method3, c4, r4, t4, method4)
}
\arguments{
\item{d}{serial correlation of contamination between the primary increments}

\item{N}{length of the production}

\item{plim}{the upper limit for graphing the fraction nonconforming or proportion of contaminated increments}

\item{type}{what type of graph we want to produce such as \code{D} or \code{ND}. \code{\link{compare_plans}} produces a graphical display of \eqn{P_D} or \eqn{P_{ND}} versus \eqn{p} depending on the \code{D} or \code{ND} of type}

\item{c1, c2, c3, c4}{acceptance numbers}

\item{r1, r2, r3, r4}{number of primary increments in a grab sample or grab sample size}

\item{t1, t2, t3, t4}{number of grab samples}

\item{method1, method2, method3, method4}{what sampling method we have applied such as \code{'systematic'} or \code{'random'} selection methods}
}
\value{
Probability of detection or non detection vs limiting fraction curves
}
\description{
This function allows comparison of different sampling schemes, which can be systematic and random sampling of primary increments or grab sampling of blocks of primary increments.  A graphical display of the probability of detection \eqn{P_D} or probability of non detection \eqn{P_{ND}} versus fraction nonconforming \eqn{p} for up to four selected schemes will be produced.
}
\examples{
c1 <- 0
c2 <- 0
c3 <- 0
c4 <- 0
r1 <- 1
r2 <- 10
r3 <- 30
r4 <- 75
t1 <- 750
t2 <- 75
t3 <- 25
t4 <- 10
d <- 0.99
N <- 1e9
method1 <- method2 <- method3 <- method4 <- 'systematic'
plim <- 0.10
compare_plans(d, N, plim, type ='D', c1, r1, t1, method1, c2, r2, t2, method2)
compare_plans(d, N, plim, type ='D', c1, r1, t1, method1, c2, r2, t2, method2,
                        c3, r3, t3, method3)
compare_plans(d, N, plim, type ='D', c1, r1, t1, method1, c2, r2, t2, method2,
                        c3, r3, t3, method3, c4, r4, t4, method4)
compare_plans(d, N, plim, type ='ND', c1, r1, t1, method1, c2, r2, t2, method2,
                        c3, r3, t3, method3, c4, r4, t4, method4)

}
