% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AOQL_grab_A.R
\name{AOQL_grab_A}
\alias{AOQL_grab_A}
\title{Construction of  AOQ curve and calculate AOQL value based on limiting fraction}
\usage{
AOQL_grab_A(c, r, t, d, N, method, plim)
}
\arguments{
\item{c}{acceptance number}

\item{r}{nurber of primary increments in a grab sample or grab sample size}

\item{t}{number of grab samples}

\item{d}{serial correlation of contamination between the primary increments}

\item{N}{length of the production}

\item{method}{what sampling method we have applied such as \code{'systematic'} or \code{'random'} selection methods}

\item{plim}{the upper limit for graphing the fraction nonconforming or proportion of contaminated increments}
}
\value{
AOQ curve and AOQL value based on on limiting fraction
}
\description{
\code{\link{AOQL_grab_A}} provides the AOQ curve and calculates AOQL value based on limiting fraction of contaminated increments.
}
\details{
Since \eqn{P_{ND}} is the probability of non-detection, \eqn{p} is the limiting fraction of contaminated increments and the outgoing contaminated proportion of primary increments is given by \eqn{AOQ} as the product \eqn{pP_{ND}}.
          The quantity \eqn{AOQL} is defined as the maximum proportion of outgoing contaminated primary increments and is given by \deqn{AOQL ={\max_{0\leq p\leq 1}}{pP_{ND}}}
}
\examples{
  c <-  0
  r <-  25
  t <-  30
  d <-  0.99
  N <-  1e9
  method <- 'systematic'
  plim <- 0.30
  AOQL_grab_A(c, r, t, d, N, method, plim)
}
\seealso{
\link{prob_detect}
}
