% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_share.R
\name{drive_share}
\alias{drive_share}
\alias{drive_share_anyone}
\title{Share Drive files}
\usage{
drive_share(
  file,
  role = c("reader", "commenter", "writer", "fileOrganizer", "owner", "organizer"),
  type = c("user", "group", "domain", "anyone"),
  ...,
  verbose = deprecated()
)

drive_share_anyone(file, verbose = deprecated())
}
\arguments{
\item{file}{Something that identifies the file(s) of interest on your Google
Drive. Can be a character vector of names/paths, a character vector of file
ids or URLs marked with \code{\link[=as_id]{as_id()}}, or a \code{\link{dribble}}.}

\item{role}{Character. The role to grant. Must be one of:
\itemize{
\item owner (not allowed in shared drives)
\item organizer (applies to shared drives)
\item fileOrganizer (applies to shared drives)
\item writer
\item commenter
\item reader
}}

\item{type}{Character. Describes the grantee. Must be one of:
\itemize{
\item user
\item group
\item domain
\item anyone
}}

\item{...}{Name-value pairs to add to the API request. This is where you
provide additional information, such as the \code{emailAddress} (when grantee
\code{type} is \code{"group"} or \code{"user"}) or the \code{domain} (when grantee type is
\code{"domain"}). Read the API docs linked below for more details.}

\item{verbose}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This logical argument to
individual googledrive functions is deprecated. To globally suppress
googledrive messaging, use \code{options(googledrive_quiet = TRUE)} (the default
behaviour is to emit informational messages). To suppress messaging in a
more limited way, use the helpers \code{\link[=local_drive_quiet]{local_drive_quiet()}} or
\code{\link[=with_drive_quiet]{with_drive_quiet()}}.}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per file.
There will be extra columns, \code{shared} and
\code{permissions_resource}.
}
\description{
Grant individuals or other groups access to files, including permission to
read, comment, or edit. The returned \code{\link{dribble}} will have extra columns,
\code{shared} and \code{permissions_resource}. Read more in \code{\link[=drive_reveal]{drive_reveal()}}.

\code{drive_share_anyone()} is a convenience wrapper for a common special case:
"make this \code{file} readable by 'anyone with a link'".
}
\examples{
\dontshow{if (drive_has_token()) withAutoprint(\{ # examplesIf}
# Create a file to share
file <- drive_example_remote("chicken_doc") |>
  drive_cp(name = "chicken-share.txt")

# Let a specific person comment
file <- file |>
  drive_share(
    role = "commenter",
    type = "user",
    emailAddress = "susan@example.com"
  )

# Let a different specific person edit and customize the email notification
file <- file |>
  drive_share(
    role = "writer",
    type = "user",
    emailAddress = "carol@example.com",
    emailMessage = "Would appreciate your feedback on this!"
  )

# Let anyone read the file
file <- file |>
  drive_share(role = "reader", type = "anyone")
# Single-purpose wrapper function for this
drive_share_anyone(file)

# Clean up
drive_rm(file)
\dontshow{\}) # examplesIf}
}
\seealso{
Wraps the \code{permissions.create} endpoint:
\itemize{
\item \url{https://developers.google.com/drive/api/v3/reference/permissions/create}
}

Drive roles and permissions are described here:
\itemize{
\item \url{https://developers.google.com/drive/api/v3/ref-roles}
}
}
