% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resampling.R
\name{crit.values}
\alias{crit.values}
\title{bootstrap critical value of statistic}
\usage{
crit.values(
  samplesize,
  statistic,
  tuning = NULL,
  k_estimator,
  boot.param = 500,
  alpha = 0.05
)
}
\arguments{
\item{samplesize}{number of observations in the sample}

\item{statistic}{test statistic to be used}

\item{tuning}{tuning parameter used for the test statistic (\code{NULL} stands for no tuning parameter needed)}

\item{k_estimator}{value of the estimated \code{shape} parameter}

\item{boot.param}{number of bootstrap iterations}

\item{alpha}{significance level of the test}
}
\value{
returns the critical value for the goodness-of-fit test using the \code{statistic}.
}
\description{
bootstrap critical value of statistic
}
\examples{
crit.values(samplesize=20,statistic=HME1,tuning=1,k_estimator=2,boot.param=100,alpha=0.05)

}
