% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IGtest.R
\name{test.KS}
\alias{test.KS}
\title{The Kolmogorov-Smirnov goodness-of-fit test for the inverse Gaussian family}
\usage{
test.KS(data, B = 500)
}
\arguments{
\item{data}{a vector of positive numbers.}

\item{B}{number of bootstrap iterations used to obtain p value.}
}
\value{
a list containing the value of the name of the test statistic, the value of the test statistic, the bootstrap p value, the values of the estimators, and the number of bootstrap iterations: \cr
\describe{
        \item{\code{$Test}}{the name of the used test statistic.}
        \item{\code{$T.value}}{the value of the test statistic.}
        \item{\code{$p.value}}{the approximated p value.}
        \item{\code{$par.est}}{the estimated parameters.}
        \item{\code{$boot.run}}{number of bootstrap iterations.}
}
}
\description{
This function computes the goodness-of-fit test for the inverse Gaussian family in the spirit of Kolmogorov and Smirnov. Note that this tests the composite hypothesis of fit to the family of inverse Gaussian distributions, i.e. a bootstrap procedure is implemented to perform the test.
}
\details{
The Kolmogorov Smirnov test is computed as described in Allison et. al. (2019). The p value is obtained by a parametric bootstrap procedure.
}
\examples{
test.KS(rmutil::rinvgauss(20,2,1),B=100)

}
\references{
Allison, J.S., Betsch, S., Ebner, B., Visagie, I.J.H. (2019) "New weighted \eqn{L^2}-type tests for the inverse Gaussian distribution", arXiv:1910.14119. \href{https://arxiv.org/abs/1910.14119}{LINK}
}
