% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmm.R
\name{gmm}
\alias{gmm}
\title{Create a Gaussian mixture model}
\usage{
gmm(alpha, mu, sigma, var = rownames(mu))
}
\arguments{
\item{alpha}{A positive numeric vector containing the mixture proportions. If
the sum of these proportions is not 1, a normalization is performed by
dividing them by this sum.}

\item{mu}{A numeric matrix containing the mean vectors bound by column.}

\item{sigma}{A list containing the covariance matrices.}

\item{var}{A character vector containing the variable names (by default the
row names of \code{mu}).}
}
\value{
A list of class \code{gmm} containing the elements \code{alpha},
\code{mu} and \code{sigma} passed as arguments (completed with the variable
names passed as argument \code{var}).
}
\description{
This function creates a Gaussian mixture model as an object of S3 class
\code{gmm}. A Gaussian mixture model is a weighted sum of multivariate
Gaussian distributions:
\deqn{p(x) = \sum_{i = 1}^M \alpha_i \mathcal{N}(x | \mu_i, \Sigma_i)}
where \eqn{\alpha_i} is the \eqn{i}th mixture proportion such that
\eqn{\alpha_i > 0} and \eqn{\sum_{i = 1}^M \alpha_i = 1}, \eqn{\mu_i} the
mean vector and \eqn{\Sigma_i} the covariance matrix of the \eqn{i}th mixture
component (Bilmes, 1998). Since conditional distributions can be derived from
joint distributions, the \code{gmm} class is also used to work with
conditional Gaussian mixture models (see function \code{\link{conditional}}
to explicit their parameters). Finally, note that a one-component Gaussian
mixture model can be created with function \code{\link{add_var}} (by passing
\code{NULL} as argument \code{gmm}), which allows to quickly initialize a
\code{gmm} object that can be passed to a learning function.
}
\examples{
gmm_1 <- gmm(alpha = c(0.2, 0.5, 0.3),
             mu = matrix(c(109, 91, 44, 160, 41, 99, 87, 27, 173, 40, 86, 65,
                           35, 161, 40),
                         nrow = 5),
             sigma = list(matrix(c(208, 240, 32, 17, -6, 240, 378, 40, 55, -38,
                                   32, 40, 15, -2, 1, 17, 55, -2, 47, -13, -6,
                                   -38, 1, -13, 127),
                                 nrow = 5),
                          matrix(c(242, 270, 82, 10, 49, 270, 363, 83, 44, 19,
                                   82, 83, 38, -2, 15, 10, 44, -2, 45, -7, 49,
                                   19, 15, -7, 137),
                                 nrow = 5),
                          matrix(c(109, 102, 41, 11, 29, 102, 128, 34, 38, 10,
                                   41, 34, 36, -9, 16, 11, 38, -9, 56, -5, 29,
                                   10, 16, -5, 138),
                                 nrow = 5)),
             var = c("WAIST", "WEIGHT", "FAT", "HEIGHT", "AGE"))

}
\references{
Bilmes, J. A. (1998). A Gentle Tutorial of the EM Algorithm and its
Application to Parameter Estimation for Gaussian Mixture and Hidden Markov
Models. Technical report, International Computer Science Institute.
}
\seealso{
\code{\link{gmbn}}, \code{\link{gmdbn}}
}
