% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_message.R
\name{gm_save_attachment}
\alias{gm_save_attachment}
\title{Save the attachment to a file}
\usage{
gm_save_attachment(x, filename)
}
\arguments{
\item{x}{attachment to save}

\item{filename}{location to save to}
}
\description{
This is a low level function that only works on attachments retrieved with \code{\link[=gm_attachment]{gm_attachment()}}.
To save an attachment directly from a message see \code{\link[=gm_save_attachments]{gm_save_attachments()}},
which is a higher level interface more suitable for most uses.
}
\examples{
\dontrun{
my_attachment <- gm_attachment("a32e324b", "12345")
# save attachment to a file
gm_save_attachment(my_attachment, "photo.jpg")
}
}
\seealso{
Other message: 
\code{\link{gm_attachment}()},
\code{\link{gm_delete_message}()},
\code{\link{gm_import_message}()},
\code{\link{gm_insert_message}()},
\code{\link{gm_messages}()},
\code{\link{gm_message}()},
\code{\link{gm_modify_message}()},
\code{\link{gm_save_attachments}()},
\code{\link{gm_send_message}()},
\code{\link{gm_trash_message}()},
\code{\link{gm_untrash_message}()}
}
\concept{message}
