% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-grace.R
\name{Grace}
\alias{Grace}
\title{Create \code{Grace} Object}
\usage{
Grace(i, to = NULL, slash = NULL)
}
\arguments{
\item{i}{A single positive integer, which represents the position
of the \code{Grace} object in a musical line.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the \code{Grace} object.}

\item{slash}{Optional. A single logical, which indicates if there is
a slash symbol on the grace note or chord. The default value is \code{TRUE}.}
}
\value{
A list of class \code{Grace}.
}
\description{
Create a \code{Grace} object. The \code{Grace} object can be added to an existing
note or chord. It will turn the note or chord to a grace note or chord.
}
\details{
A \code{Grace} object can not be added to a rest, tuplet, or note or chord
that has a dotted duration. There must be a note or chord after
the note or chord where the \code{Grace} object is added.
}
\examples{
# Create a `Grace`
grace <- Grace(1)
grace

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "D4"), c(0.5, 1)) + grace
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a \code{Grace} object to a \code{Music} object.
}
