% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-fermata.R
\name{Fermata}
\alias{Fermata}
\title{Create \code{Fermata} Object}
\usage{
Fermata(i, to = NULL, shape = NULL, above = NULL)
}
\arguments{
\item{i}{A single positive integer, which represents the position
of the fermata in a musical line.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the fermata.}

\item{shape}{Optional. A single character, which indicates the shape of
the fermata. The default value is \code{"normal"}. See the \emph{Details} section.}

\item{above}{Optional. A single logical, which indicates whether the
fermata symbol should appear above or below the staff.}
}
\value{
A list of class \code{Fermata}.
}
\description{
Create a \code{Fermata} object to represent a fermata symbol.
}
\details{
Supported fermata shapes:
\itemize{
\item "normal"
\item "short" or "angled"
\item "long" or "square"
\item "very short" or "double-angled"
\item "very long" or "double-square"
\item "long (Henze)" or "double-dot"
\item "short (Henze)" or "half-curve"
\item "curlew"
}

The shapes are from
\href{https://w3c.github.io/musicxml/musicxml-reference/data-types/fermata-shape/}{the MusicXML specification}
and MuseScore.
}
\examples{
# Create a fermata
fermata <- Fermata(1)
fermata

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "D4")) + fermata
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a \code{Fermata} to
a \code{Music} object.
}
