% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-breath.R
\name{Breath}
\alias{Breath}
\title{Create \code{Breath} Object}
\usage{
Breath(i, to = NULL, symbol = NULL)
}
\arguments{
\item{i}{A single positive integer, which represents the position
of the breath mark in a musical line.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the breath mark.}

\item{symbol}{Optional. A single character which can be \code{"comma"},
\code{"tick"}, \code{"upbow"}, and \code{"salzedo"}. It represents the symbol
used for the breath mark. The default symbol is \code{"comma"}. See
\href{https://w3c.github.io/musicxml/musicxml-reference/data-types/breath-mark-value/}{the MusicXML specification}.}
}
\value{
A list of class \code{Breath}.
}
\description{
Create a \code{Breath} object to represent a breath mark.
}
\examples{
# Create a breath mark
breath <- Breath(1)
breath

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "D4")) + breath
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a breath mark to a \code{Music} object.
}
