% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-articulation.R
\name{Articulation}
\alias{Articulation}
\title{Create \code{Articulation} Object}
\usage{
Articulation(name, i, to = NULL)
}
\arguments{
\item{name}{A single character, which represents the name or symbol
of the articulation. For example, to create a staccato dot, \code{name} can
be \code{"staccato"} or \code{"."}, which looks like a staccato. See the
\emph{Details} section for supported articulations.}

\item{i}{A single positive integer, which represents the position
of the articulation in a musical line.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the articulation.}
}
\value{
A list of class \code{Articulation}.
}
\description{
Create an \code{Articulation} object to represent an articulation mark.
}
\details{
Supported articulation names and symbols:
\itemize{
\item "accent" or ">"
\item "staccato" or "."
\item "staccatissimo" or "'"
\item "tenuto" or "-"
\item "tenuto-staccato", "detached-legato" or "-."
\item "marcato", "strong-accent" or "^"
\item "scoop"
\item "plop"
\item "doit"
\item "fall" or "falloff"
\item "stress" or ","
\item "unstress" or "u"
\item "soft accent", "soft-accent" or "<>"
}

The names are from
\href{https://w3c.github.io/musicxml/musicxml-reference/elements/articulations/}{the MusicXML specification}
and MuseScore.
}
\examples{
# Create a staccato
staccato <- Articulation(".", 1)
staccato

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "D4")) + staccato
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding an \code{Articulation} to
a \code{Music} object.
}
