% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gist_create.R
\name{gist_create}
\alias{gist_create}
\title{Create a gist}
\usage{
gist_create(
  files = NULL,
  description = "",
  public = TRUE,
  browse = TRUE,
  code = NULL,
  filename = "code.R",
  knit = FALSE,
  knitopts = list(),
  renderopts = list(),
  include_source = FALSE,
  imgur_inject = FALSE,
  rmarkdown = FALSE,
  ...
)
}
\arguments{
\item{files}{Files to upload. this or \code{code} param must be passed}

\item{description}{(character) Brief description of gist (optional)}

\item{public}{(logical) Whether gist is public (default: TRUE)}

\item{browse}{(logical) To open newly create gist in default browser
(default: TRUE)}

\item{code}{Pass in any set of code. This can be a single R object, or
many lines of code wrapped in quotes, then curly brackets (see examples
below). this or \code{files} param must be passed}

\item{filename}{Name of the file to create, only used if \code{code}
parameter is used. Default to \code{code.R}}

\item{knit}{(logical) Knit code before posting as a gist? If the file
has a \code{.Rmd}  or \code{.Rnw} extension, we run the file with
\code{\link[knitr]{knit}}, and if it has a \code{.R} extension, then
we use \code{\link[rmarkdown]{render}}}

\item{knitopts, renderopts}{(list) List of variables passed on to
\code{\link[knitr]{knit}}, or \code{\link[rmarkdown]{render}}}

\item{include_source}{(logical) Only applies if \code{knit=TRUE}. Include
source file in the gist in addition to the knitted output.}

\item{imgur_inject}{(logical) Inject \code{\link[knitr]{imgur_upload}}
into your \code{.Rmd} file to upload files to \url{https://imgur.com/}.
This will be ignored  if the file is a sweave/latex file because the
rendered pdf can't be uploaded anyway. Default: FALSE}

\item{rmarkdown}{(logical) If \code{TRUE}, use \code{\link[rmarkdown:render]{rmarkdown::render()}} instead of
\code{\link[knitr:knit]{knitr::knit()}} to render the document.}

\item{...}{Further args passed on to \code{\link[crul]{verb-POST}}}
}
\description{
Create a gist
}
\examples{
\dontrun{
file <- tempfile()
cat("hello world", file = file)
gist_create(files=file, description='a new cool gist')

file1 <- tempfile()
file2 <- tempfile()
cat("foo bar", file = file1)
cat("foo bar", file = file2)
gist_create(files=c(file1, file2), description='spocc demo files')

# include any code by passing to the code parameter
gist_create(code={'
x <- letters
numbers <- runif(10)
numbers
'})

# Knit an .Rmd file before posting as a gist
file <- system.file("examples", "stuff.Rmd", package = "gistr")
gist_create(file, description='a new cool gist', knit=TRUE)

file <- system.file("examples", "plots.Rmd", package = "gistr")
gist_create(file, description='some plots', knit=TRUE)

# an .Rnw file
file <- system.file("examples", "rnw_example.Rnw", package = "gistr")
gist_create(file)
gist_create(file, knit=TRUE)

# Knit code input before posting as a gist
gist_create(code={'
```{r}
x <- letters
(numbers <- runif(8))
```
'}, knit=TRUE)

url <- "https://raw.githubusercontent.com/ropensci/geojsonio/master/inst/examples/zillow_or.geojson"
json <- crul::HttpClient$new(url)$get()$parse("UTF-8")
gist_create(code = json, filename = "zillow_or.geojson")

# Knit and include source file, so both files are in the gist
file <- system.file("examples", "stuff.Rmd", package = "gistr")
gist_create(file, knit=TRUE, include_source=TRUE)

gist_create(code={'
```{r}
x <- letters
(numbers <- runif(8))
```
'}, filename="code.Rmd", knit=TRUE, include_source=TRUE)

# Uploading images created during knit process
## using imgur - if you're file uses imgur or similar, you're good
file <- system.file("examples", "plots_imgur.Rmd", package = "gistr")
cat(readLines(file), sep = "\n") # peek at file
gist_create(file, knit=TRUE)
## if not, GitHub doesn't allow upload of binary files via the HTTP API 
## (which gistr uses) - so see gist_create_git(), which uses git
file <- system.file("examples", "plots.Rmd", package = "gistr")
gist_create(file, knit=TRUE, imgur_inject = TRUE)
## works with ggplot2 as well
file <- system.file("examples", "ggplot_imgur.Rmd", package = "gistr")
gist_create(file, knit=TRUE)

# Render `.R` files
file <- system.file("examples", "example1.R", package = "gistr")
cat(readLines(file), sep = "\n") # peek at file
gist_create(file, knit = TRUE)
gist_create(file, knit = TRUE, include_source = TRUE)
## many files
(file1 <- system.file("examples", "example1.R", package = "gistr"))
(file2 <- system.file("examples", "example2.R", package = "gistr"))
cat(readLines(file1), sep = "\n") # peek at file
cat(readLines(file2), sep = "\n") # peek at file
gist_create(files=list(file1, file2), knit = TRUE)
### three at once, some .R and some .Rmd
file3 <- system.file("examples", "plots_imgur.Rmd", package = "gistr")
gist_create(files=list(file1, file2, file3), knit = TRUE)
gist_create(files=list(file1, file2, file3), knit = TRUE, 
  include_source = TRUE)

# Use rmarkdown::render instead of knitr::knit
file <- system.file("examples", "rmarkdown_eg.Rmd", package = "gistr")
gist_create(file, knit = TRUE, rmarkdown = TRUE, imgur_inject = TRUE,
   renderopts = list(output_format = "md_document"))
}
}
\seealso{
\code{\link[=gist_create_obj]{gist_create_obj()}}, \code{\link[=gist_create_git]{gist_create_git()}}
}
