% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-get-airports.R
\encoding{UTF-8}
\name{gisco_get_airports}
\alias{gisco_get_airports}
\title{Airports dataset}
\source{
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/transport-networks}.

Copyright:
\url{https://ec.europa.eu/eurostat/web/gisco/geodata}.
}
\usage{
gisco_get_airports(
  year = c(2013, 2006),
  country = NULL,
  cache_dir = NULL,
  update_cache = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{year}{character string or number. Release year of the file. One of
\code{2013}, \code{2006}.}

\item{country}{character vector of country codes. It could be either a
vector of country names, a vector of ISO3 country codes or a vector of
Eurostat country codes. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{update_cache}{logical. Should the cached file be refreshed?. Default
is \code{FALSE}. When set to \code{TRUE} it would force a new download.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
This dataset includes the location of over 11,800 Pan European airports and
heliports. The airports are identified using the International Civil
Aviation Organisation (ICAO) airport codes.
}
\details{
Dataset includes objects in \href{https://epsg.io/4326}{EPSG:4326}.
}
\examples{
\dontshow{if (gisco_check_access()) withAutoprint(\{ # examplesIf}
airp <- gisco_get_airports(year = 2013)
coast <- giscoR::gisco_coastal_lines

if (!is.null(airp)) {
  library(ggplot2)

  ggplot(coast) +
    geom_sf(fill = "grey10", color = "grey20") +
    geom_sf(
      data = airp, color = "#00F0FF",
      size = 0.2, alpha = 0.25
    ) +
    theme_void() +
    theme(
      plot.background = element_rect(fill = "black"),
      text = element_text(color = "white"),
      panel.grid = element_blank(),
      plot.title = element_text(face = "bold", hjust = 0.5),
      plot.subtitle = element_text(face = "italic", hjust = 0.5)
    ) +
    labs(
      title = "Airports in Europe", subtitle = "Year 2013",
      caption = "Source: Eurostat, Airports 2013 dataset."
    ) +
    # Center in Europe: EPSG 3035
    coord_sf(
      crs = 3035,
      xlim = c(2377294, 7453440),
      ylim = c(1313597, 5628510)
    )
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other transport networks datasets:
\code{\link{gisco_get_ports}()}
}
\concept{transport}
