% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-donut-slice.R
\name{geom_donut_slice}
\alias{geom_donut_slice}
\title{Create donut slice plot using Cartesian coordinates system}
\usage{
geom_donut_slice(
  mapping = NULL,
  data = NULL,
  show.legend = NA,
  na.rm = FALSE,
  inherit.aes = TRUE,
  slice_angle = 180,
  init_angle = 0,
  x0 = 0,
  y0 = 0,
  r1 = 1,
  r2 = 0.65,
  color = "black",
  alpha = 1,
  linewidth = 0.5,
  slice_position = NA,
  labels_with_tick = FALSE,
  link_with_origin = FALSE,
  labels_family = "",
  labels_size = 5,
  labels_col = "black",
  labels_hjust = 0.5,
  labels_vjust = 0.5,
  labels_fontface = "plain",
  labels_lineheight = 1.2,
  tick_lwd = 1,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{aes()} or
\code{aes_()}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{to be displayed in this layer}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them.}

\item{slice_angle}{Pie slice angle}

\item{init_angle}{Starting angle}

\item{x0}{Init position x}

\item{y0}{Init position y}

\item{r1}{Outer circle radius}

\item{r2}{Inner circle radius, should inferior  to \code{r1} value.
\code{r1} and \code{r2} values are swapped otherwise.}

\item{color}{Plot border colour}

\item{alpha}{Filling colour transparency [0,1]}

\item{linewidth}{Plot border size}

\item{slice_position}{Pie slice position}

\item{labels_with_tick}{\code{TRUE} if we want tick when labelling categories}

\item{link_with_origin}{\code{TRUE} if we want to link
slice borders with origin}

\item{labels_family}{Labels font family}

\item{labels_size}{Labels font size}

\item{labels_col}{Labels colour}

\item{labels_hjust}{Labels horizontal adjusting}

\item{labels_vjust}{Labels vertical adjusting}

\item{labels_fontface}{Labels font face}

\item{labels_lineheight}{Labels line height}

\item{tick_lwd}{Ticks Size}

\item{...}{other arguments passed on to \code{layer()}.}
}
\value{
A ggplot2 layer.
}
\description{
There are two  arguments absolutely needed in  \code{aes()} mappings:
\itemize{
\item \code{cat} A discrete categories vector.
\item \code{val} A numerical values vector.
}
}
\examples{
my_df <- data.frame(cat = c("Apple", "Banana", "Pineapple"), val = c(2.65, 4.5, 6.25))
my_df |>
  ggplot2::ggplot() +
  geom_donut_slice(ggplot2::aes(cat = cat, val = val)) +
  ggplot2::coord_equal()

}
