% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{print.ggrasp}
\alias{print.ggrasp}
\title{print.ggrasp}
\usage{
\method{print}{ggrasp}(x, type, rank.level, ...)
}
\arguments{
\item{x}{ggrasp-class object to be printed}

\item{type}{Format of the data printed, either "tree" (new hampshire extended style), "table" where the medoids or representative are shown in a table format, or "list" where the information is shown in a pseudo-fasta format}

\item{rank.level}{Maximum level of the rank to show. Ignored pre-clustering. After clustering, 0 will show only the medoids, -1 will show all values independent of rank, and any value >= 1 will show all the genomes less than or equal to that rank (including medoids). Default is 0 (only the medoids)}

\item{...}{ignored}
}
\description{
prints formatted information from a class GGRaSP object. Multiple output options are available.
}
\examples{
#Getting the ggrasp object
Enter.tree <- ggrasp.load(system.file("extdata", "Enter.kSNP.tree", package="ggrasp"), 
file.format = "tree", rank.file =system.file("extdata", "Enter.kSNP.ranks", package="ggrasp"));
\donttest{Enter.tree.cluster <- ggrasp.cluster(Enter.tree)}

#Default examples: using the initizalized ggrasp object will print the newick tree string 
print(Enter.tree);

# Using the clustered ggrasp object will print the medoids and their respective clusters
\donttest{print(Enter.tree.cluster)}
#Below are examples of using different output formats and rank levels
\donttest{print(Enter.tree.cluster, "tree")}
\donttest{print(Enter.tree.cluster, "table", 1)}
\donttest{print(Enter.tree.cluster, "table", 0)}
}
