% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend-draw.R
\name{draw_key_lexis}
\alias{draw_key_lexis}
\alias{draw_key_pointless}
\alias{draw_key_sabline}
\title{Key glyphs for legends}
\usage{
draw_key_pointless(data, params, size)

draw_key_sabline(data, params, linewidth, size)

draw_key_lexis(data, params, linewidth, size)
}
\arguments{
\item{data}{A single row data frame containing the scaled aesthetics to
display in this key}

\item{params}{A list of additional parameters supplied to the geom.}

\item{size}{Width and height of key in mm.}
}
\value{
A grid grob.
}
\description{
Each geom has an associated function that draws the key when
the geom needs to be displayed in a legend. These functions are
called  draw_key_*(), where * stands for the name of the
respective key glyph. The key glyphs of the \code{\link[=geom_lexis]{geom_lexis()}}
function draws a short line of 45° with a point at the end,
see examples below.
}
\examples{
df1 <- data.frame(x = c(0, 1), xend = c(2, 3), grp = c("A", "B"))
ggplot(df1, aes(x, xend = xend, color = grp)) +
  geom_lexis()

# the glyph can be changed using the `key_glyph` argument
ggplot(mtcars, aes(wt, mpg, color = "red")) +
  geom_point(key_glyph = "lexis")
}
\keyword{internal}
