% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-nodes.R
\name{geom_nodetext}
\alias{geom_nodetext}
\alias{geom_nodelabel}
\title{Label the nodes of a network.}
\usage{
geom_nodetext(
  mapping = NULL,
  data = NULL,
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_nodelabel(
  mapping = NULL,
  data = NULL,
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  label.padding = unit(0.25, "lines"),
  label.r = unit(0.15, "lines"),
  label.size = 0.25,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{A position adjustment to use on the data for this layer.
Cannot be jointy specified with \code{nudge_x} or \code{nudge_y}. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
\item A string nameing the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{parse}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.
Cannot be jointly specified with \code{position}.}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted. \code{check_overlap} happens at draw time and in
the order of the data. Therefore data should be arranged by the label
column before calling \code{geom_text()}. Note that this argument is not
supported by \code{geom_label()}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{label.padding}{Amount of padding around label. Defaults to 0.25 lines.}

\item{label.r}{Radius of rounded corners. Defaults to 0.15 lines.}

\item{label.size}{Size of label border, in mm.}
}
\description{
All arguments to these geoms are identical to those of
\code{\link[ggplot2]{geom_text}} and \code{\link[ggplot2]{geom_label}}.
}
\examples{
## geom_nodetext examples

if (require(network) && require(sna)) {
  n <- network(rgraph(10, tprob = 0.2), directed = FALSE)

  # just node labels
  ggplot(n, aes(x, y)) +
    geom_nodetext(aes(label = vertex.names)) +
    theme_blank()

  # with nodes underneath
  ggplot(n, aes(x, y)) +
    geom_nodes(colour = "gold", size = 9) +
    geom_nodetext(aes(label = vertex.names)) +
    theme_blank()

  # with nodes and edges
  ggplot(n, aes(x, y, xend = xend, yend = yend)) +
    geom_edges(colour = "gold") +
    geom_nodes(colour = "gold", size = 9) +
    geom_nodetext(aes(label = vertex.names)) +
    theme_blank()
}


## geom_nodelabel examples

if (require(network) && require(sna)) {
  data(flo, package = "network")
  n <- network(flo, directed = FALSE)

  # with text labels
  ggplot(n, aes(x, y, xend = xend, yend = yend)) +
    geom_edges(colour = "grey50") +
    geom_nodelabel(aes(label = vertex.names)) +
    theme_blank()

  # with text labels coloured according to degree centrality
  n \%v\% "degree" <- degree(n)
  ggplot(n, aes(x, y, xend = xend, yend = yend)) +
    geom_edges(colour = "grey50") +
    geom_nodelabel(aes(label = vertex.names, fill = degree)) +
    scale_fill_gradient(low = "gold", high = "tomato") +
    theme_blank()

  # label only a subset of all nodes
  high_degree <- function(x) {
    x[ x$degree > median(x$degree), ]
  }
  ggplot(n, aes(x, y, xend = xend, yend = yend)) +
    geom_edges(colour = "steelblue") +
    geom_nodes(aes(size = degree), colour = "steelblue") +
    geom_nodelabel(aes(label = vertex.names),
      data = high_degree,
      colour = "white", fill = "tomato"
    ) +
    theme_blank()
}

}
