% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-debug.R
\name{geom_debug_panel}
\alias{geom_debug_panel}
\alias{geom_debug}
\alias{geom_debug_group}
\title{Geoms that print input data to console.}
\usage{
geom_debug_panel(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  dbgfun.data = "head",
  dbgfun.data.args = list(),
  dbgfun.params = "summary",
  dbgfun.params.args = list(),
  dbgfun.print = "print",
  dbgfun.print.args = list(),
  parse = NULL,
  orientation = NULL,
  nudge_x = 0,
  nudge_y = 0,
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)

geom_debug(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  summary.fun = "head",
  summary.fun.args = list(),
  parse = NULL,
  orientation = NULL,
  nudge_x = 0,
  nudge_y = 0,
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)

geom_debug_group(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  dbgfun.data = "head",
  dbgfun.data.args = list(),
  dbgfun.params = "summary",
  dbgfun.params.args = list(),
  dbgfun.print = "print",
  dbgfun.print.args = list(),
  parse = NULL,
  orientation = NULL,
  nudge_x = 0,
  nudge_y = 0,
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. If specified and
\code{inherit.aes = TRUE} (the default), is combined with the default
mapping at the top level of the plot. You only need to supply
\code{mapping} if there isn't a mapping defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{dbgfun.data, dbgfun.params, summary.fun}{The functions as character
strings giving their names or as named or anonymous function objects, to be
used to summarize the \code{data} and the \code{params} objects received as
input by the geometry.}

\item{dbgfun.data.args, dbgfun.params.args, summary.fun.args}{A named list of
additional arguments to be passed to \code{dbgfun.data} and
\code{dbgfun.params}.}

\item{dbgfun.print}{A function used to print the \code{data} object received
as input.}

\item{dbgfun.print.args}{A named list. Currently ignored!}

\item{parse, orientation}{Ignored. Helps avoid warnings.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustments to nudge the
starting position. The units for \code{nudge_x} and \code{nudge_y} are the
same as for the data units on the x-axis and y-axis.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. There
  are three types of arguments you can use here:

  \itemize{ \item Aesthetics: to set an aesthetic to a fixed value, like
  \code{color = "red"} or \code{size = 3}. \item Other arguments to the
  layer, for example you override the default \code{stat} associated with the
  layer. \item Other arguments passed on to the stat. }}
}
\value{
The panel function of this geometry always returns a
  \code{\link[grid]{nullGrob}}, the legend is is also set to
  \code{\link[grid]{nullGrob}}. This geometry used for its text printing side
  effect.
}
\description{
The debug geoms are used to print to the console a summary of the object being
received by geoms' draw functions as input \code{data} and \code{parameters}
objects.
}
\details{
It can be useful when debugging the code of statistics or to learn how the
stats and geoms work in 'ggplot2' (>= 3.0.0).

The intended use of \code{geom_debug_panel()} and
  \code{geom_debug_group()} is to explore the data as
  they are used in a plot layer to produce graphical output. Geometries
  can be defined using draw functions that receive as input data corresponding
  to a single group at a time, or draw functions that receive as input all
  data to be drawn in a panel at a time, possibly including multiple
  groups. Function \code{geom_debug()} is identical to
  \code{geom_debug_panel()}, and included for backwards compatibility.

  These \emph{debug} geoms are very unusual in that they do not produce
  visible graphic output. They "draw" a \code{grid.null()} grob (graphical
  object) when the plot is rendered. Also, differently to normal geometries,
  they print the \code{data} and \code{params} objects or a summary of them
  to the R console. The summary is obtained using the functions passed as
  arguments to their formal parameter \code{dbgfun.data} and
  \code{dbgfun.params}. The \code{data} and \code{params} objects are passed
  as the first positional argument to these functions and the values they
  return are printed.

  If \code{dbgfun.data = "I"} is passed, the \code{data} object is printed as
  is. In contrast, if \code{dbgfun.data = NULL} is passed, the \code{data}
  object summary and its printing are not skipped. The mechanism is identical
  for \code{dbgfun.params} and \code{params}.

  Nudging with \code{nudge_x} and \code{nudge_y} behave as in
  \code{\link[ggplot2]{geom_text}}. Arguments passed to \code{position} are
  obeyed. So the effects of positions are reflected in the \code{data} object
  printed or summarized to the R console. The arguments passed to
  \code{parse} and \code{orientation} are currently ignored.

  Many aesthetics are defined as optional so that they are accepted silently
  by \code{geom_debug()} and handled by 'ggplot2' as usual. Given the number
  available extensions to 'ggplot2', it is likely that some are missing.

  The names of \code{dbgfun.data()} and \code{dbgfun.params()} are included
  in the section headers of the printout, together with panels and groups.

  In most cases, the definitions of the debug and print functions must be
  available when the \code{"gg"} object is printed and the plot rendered.
}
\note{
\code{geom_debug()} is a synonym of \code{geom_debug_panel()}, for
  backwards compatibility. Not to be used in new code.
}
\examples{
# echo to the R console \code{data} as received by geoms
ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  geom_debug_panel()

ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  geom_debug_group()

ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  geom_debug_panel(dbgfun.params = NULL)

ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  geom_debug_panel(dbgfun.data = NULL)

ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  geom_debug_panel(dbgfun.data = "head", dbgfun.data.args = list(n = 3))

ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  geom_debug_panel(dbgfun.data = "nrow", dbgfun.params = "length")

ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  geom_debug_panel(dbgfun.data = "attributes", dbgfun.params = "attributes")

ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  geom_debug_panel(dbgfun.data = "I", dbgfun.params = NULL)

# echo to the R console \code{data} as received by geoms
ggplot(mtcars, aes(cyl, mpg, colour = factor(cyl))) +
  stat_summary(fun.data = "mean_se") +
  stat_summary(geom = "debug_panel", fun.data = "mean_se")

ggplot(mtcars, aes(cyl, mpg, colour = factor(cyl))) +
  stat_summary(fun.data = "mean_se") +
  stat_summary(geom = "debug_panel", fun.data = "mean_se", dbgfun.params = NULL)

# shape data is not passed to geometries or statistics
if (requireNamespace("sf", quietly = TRUE)) {
  nc <-
    sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)

  ggplot(data = nc) +
    geom_sf(color = "darkblue", fill = "white") +
    geom_debug_panel()
}

# backwards compatibility
ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  geom_debug()

ggplot(mtcars, aes(cyl, mpg, colour = factor(cyl))) +
  stat_summary(fun.data = "mean_se") +
  stat_summary(geom = "debug", fun.data = "mean_se")

}
\seealso{
To access data, scales and grobs in a built ggplot, see
  \code{\link[ggplot2]{ggplot_build}}.
}
