% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_daylight.R
\docType{data}
\name{AnnotateDaylight}
\alias{AnnotateDaylight}
\alias{annotate_daylight}
\title{Annotate ggplot with a band indicating solar events}
\format{
An object of class \code{AnnotateDaylight} (inherits from \code{GeomPolygon}, \code{Geom}, \code{ggproto}, \code{gg}) of length 6.
}
\usage{
AnnotateDaylight

annotate_daylight(
  longitude = 0,
  latitude = 60,
  sun_prop = c("sunrise", "sunset"),
  ...
)
}
\arguments{
\item{longitude, latitude}{Geographical location that will be used
to calculate sunlight times.}

\item{sun_prop}{A vector of two solar events that should be
captured by the annotation. It will be shown as a coloured band
between these two events. Default is \code{c("sunrise", "sunset")},
but could also be \code{c("dusk", "dawn")}. See \code{\link[suncalc:getSunlightTimes]{suncalc::getSunlightTimes()}}
for all allowed solar events.}

\item{...}{Passed to the list of layer parameters.}
}
\value{
Returns a \code{\link[ggplot2:layer]{ggplot2::layer()}} which can be added to a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
}
\description{
Annotate a ggplot (currently only plots using \code{\link[=coord_hourglass]{coord_hourglass()}}
is supported) with a coloured band indicating solar events, such
as sunset and sunrise.
}
\examples{
library(ggplot2)
data(bats)

monitoring <- attr(bats, "monitoring")

ggplot(subset(bats, format(RECDATETIME, "\%Y") == "2018"),
       aes(x = RECDATETIME, col = SPECDESCSCI)) +
  annotate_daylight(monitoring$longitude[1], monitoring$latitude[1], c("sunset", "sunrise")) +
  annotate_daylight(monitoring$longitude[1], monitoring$latitude[1], c("dusk", "dawn")) +
  geom_hourglass()
}
\author{
Pepijn de Vries
}
\keyword{datasets}
