% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{getBasicStatistics}
\alias{getBasicStatistics}
\title{Determine basic statistics of the graph object}
\usage{
getBasicStatistics(ig)
}
\arguments{
\item{ig}{the graph representation of the data genealogy (in igraph format)}
}
\description{
Returns basic statistics of the graph object (number of nodes, number of edges, whether or not the
whole graph is connected, number of components, average path length, graph diameter, etc.)
}
\examples{
data(sbGeneal)
ig <- dfToIG(sbGeneal)
getBasicStatistics(ig)
}
\references{
Rutter L, VanderPlas S, Cook D, Graham MA (2019).
ggenealogy: An R Package for Visualizing Genealogical Data.
\emph{Journal of Statistical Software},
\bold{89}(13), 1--31.
\doi{10.18637/jss.v089.i13}
}
