% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{build_cell_names_r}
\alias{build_cell_names_r}
\title{Find All Possible Conditions}
\usage{
build_cell_names_r(parameter_map_r, factors_r, responses_r)
}
\arguments{
\item{parameter_map_r}{An Rcpp::List where each element is a character
vector mapping parameters to conditions. Names should correspond to
       parameters.}

\item{factors_r}{An Rcpp::List where each element is a character vector of
factor levels. Names should correspond to factor names.}

\item{responses_r}{A character vector (std::vector<std::string>) of 
response/accumulator names.}
}
\value{
An Rcpp::List with two elements:
\itemize{
  \item \code{cell_names}: Character vector of all possible condition
combinations
  \item \code{sortedFactors}: The processed factor structure used to
  generate cells
}
}
\description{
Constructs all possible condition combinations (i.e., cells)
based on experimental factors, parameter mappings, and response
definitions. Returns both cell names and sorted factor definitions.
}
\details{
The function:
\enumerate{
  \item Converts R lists to 'C++' maps for efficient processing
  \item Generates all condition combinations via Cartesian product
  \item Handles special parameter mappings (like mapping accumulators to 
 conditions)
  \item Returns both cell names and the factor structure used
}
}
\section{Typical Workflow}{

This function is typically used to:
\enumerate{
  \item Establish the full experimental design space
  \item Verify factor/parameter compatibility
  \item Generate condition labels for model specification
}
This function primarily is to debug the internal process of model building.
}

\examples{
# A simple example
p_map <- list(A = "1", B = "1", t0 = "1", mean_v = "M", sd_v = "1",
               st0 ="1")
factors <- list(S = c("s1", "s2"))
responses <- c("r1", "r2")
result <- build_cell_names_r(p_map, factors, responses)

# cat("B (2 factors), t0, mean_v (3 factors), sd_v (2 factors)")
p_map <- list(
    A = "H", B = c("S", "G"), t0 = "E", mean_v = c("D", "H", "M"),
    sd_v = c("D", "M"), st0 = "1"
)
factors <- list(
    S = c("s1", "s2", "s3"), D = c("d1", "d2"), E = c("e1", "e2"),
    G = c("g1", "g2", "g3"), H = c("h1", "h2", "h3", "h4", "h5")
)
responses <- c("r1", "r2", "r3")
result <- build_cell_names_r(p_map, factors, responses)

}
