% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{method_freqpoly}
\alias{method_freqpoly}
\title{Bivariate frequency polygon HDR estimator}
\usage{
method_freqpoly(bins = NULL)
}
\arguments{
\item{bins}{Number of bins along each axis.
Either a vector of length 2 or a scalar value which is recycled for both dimensions.
Defaults to normal reference rule (Scott, pg 87).}
}
\description{
Function used to specify bivariate frequency polygon density estimator
for \code{get_hdr()} and layer functions (e.g. \code{geom_hdr()}).
}
\details{
For more details on the use and implementation of the \verb{method_*()} functions,
see \code{vignette("method", "ggdensity")}.
}
\examples{
set.seed(1)
df <- data.frame(x = rnorm(1e3), y = rnorm(1e3))

ggplot(df, aes(x, y)) +
  geom_hdr(method = method_freqpoly()) +
  geom_point(size = 1)

# The resolution of the frequency polygon estimator can be set via `bins`
ggplot(df, aes(x, y)) +
  geom_hdr(method = method_freqpoly(bins = c(8, 25))) +
  geom_point(size = 1)

# Can also be used with `get_hdr()` for numerical summary of HDRs
res <- get_hdr(df, method = method_freqpoly())
str(res)

}
\references{
Scott, David W. Multivariate Density Estimation (2e), Wiley.
}
