% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_elements.R
\name{generate_curvature_path}
\alias{generate_curvature_path}
\title{Generate curved sequence paths}
\usage{
generate_curvature_path(
  start_angle,
  end_angle,
  radius,
  curvature,
  n_points = 100
)
}
\arguments{
\item{start_angle}{Numeric, start angle (in radians)}

\item{end_angle}{Numeric, end angle (in radians)}

\item{radius}{Numeric, path radius}

\item{curvature}{Numeric, curvature (0 = straight line, 1 = standard arc, >1 = more curved)}

\item{n_points}{Integer, number of points in the path (controls smoothness), default 100}
}
\value{
data.frame containing columns x, y (coordinates of points on the path)
}
\description{
Generates smooth sequence paths (supporting straight lines, arcs, and custom curvatures) based on start angle, end angle, radius, and curvature.
}
\keyword{internal}
