% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resid_interact.R
\name{resid_interact}
\alias{resid_interact}
\title{Panel of Interactive Versions of Diagnostic Residual Plots.}
\usage{
resid_interact(model, plots = "default", type = NA, bins = 30,
  smoother = FALSE, qqline = TRUE, scale = 0.9, theme = "bw",
  axis.text.size = 10, title.text.size = 12, title.opt = TRUE,
  nrow = NULL)
}
\arguments{
\item{model}{Model fit using either \code{lm}, \code{glm}, \code{lmer},
\code{lmerTest}, \code{lme}, or \code{glmer}.}

\item{plots}{Plots chosen to include in the panel of plots. The default panel
includes a residual plot, a normal quantile plot, an index plot,
and a histogram of the residuals. (See details in the help file
for \code{resid_panel} for the options available.)}

\item{type}{Type of residuals to use in the plot. If not specified, the
default residual type for each model type is used. (See details in the help file
for \code{resid_panel} for the options available.)}

\item{bins}{Number of bins to use when creating a histogram of the residuals.
Default is set to 30.}

\item{smoother}{Indicates whether or not to include a smoother on the index,
residual-leverage, location-scale, and residual plots. Specify TRUE or FALSE.
Default is set to FALSE.}

\item{qqline}{Indicates whether to include a 1-1 line on the qq-plot. Specify
TRUE or FALSE. Default is set to TRUE. (The option of \code{qqbands} has not
been implemented in plotly, so it is not available as an option with
\code{resid_interact}.)}

\item{scale}{Scales the size of the graphs in the panel. Takes values in (0,1].}

\item{theme}{ggplot2 theme to be used. Current options are \code{"bw"},
\code{"classic"}, and \code{"grey"} (or \code{"gray"}). Default is
\code{"bw"}.}

\item{axis.text.size}{Specifies the size of the text for the axis labels of
all plots in the panel.}

\item{title.text.size}{Specifies the size of the text for the titles of all
plots in the panel.}

\item{title.opt}{Indicates whether or not to include a title on the plots in
the panel. Specify TRUE or FALSE. Default is set to TRUE.}

\item{nrow}{Sets the number of rows in the panel.}
}
\value{
A panel of interactive residual diagnostic plots containing plots specified.
}
\description{
Creates a panel of interactive residual diagnostic plots given a model. Currently
accepts models of type "lm", "glm", "lmerMod", "lmerModLmerTest", "lme", and "glmerMod".
}
\details{
Details on the creation of the plots can be found in the details section of
  the help file for \code{resid_panel}.
}
\examples{

# Fit a model to the penguin data
penguin_model <- lme4::lmer(heartrate ~ depth + duration + (1|bird), data = penguins)

# Create the default interactive panel
resid_interact(penguin_model)

# Select all plots to include in the panel and set the smoother option to TRUE
resid_interact(penguin_model, plots = "all", smoother = TRUE)

# Select only the residual plot and qq-plot to be included in the panel and
# set the number of rows to 2
resid_interact(penguin_model, plots = c("resid", "qq"), nrow = 2)

# Choose the SAS panel of plots, change the theme to classic, and remove the
# titles of the plots
resid_interact(penguin_model, plots = "SAS", theme = "classic", title.opt = FALSE)
}
