% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main2.R
\name{gfigpd2}
\alias{gfigpd2}
\title{Fiducial inference for the generalized Pareto model with unknown threshold}
\usage{
gfigpd2(
  X,
  beta,
  threshold.init = NA,
  gamma.init = NA,
  sigma.init = NA,
  sd.gamma = NA,
  sd.sigma = NA,
  p1 = 0.9,
  p2 = 0.5,
  lambda1 = 2,
  lambda2 = 10,
  Jnumb = 50L,
  iter = 10000L,
  burnin = 2000L,
  thin = 6L,
  nchains = 4L,
  nthreads = parallel::detectCores(),
  seeds = NULL,
  allParameters = FALSE
)
}
\arguments{
\item{X}{numeric vector of data}

\item{beta}{vector of probabilities corresponding to the quantiles to be 
estimated}

\item{threshold.init}{a guess of the unknown threshold, must be in the range 
of \code{X}}

\item{gamma.init}{starting value for \code{gamma} in the MCMC}

\item{sigma.init}{starting value for \code{sigma} in the MCMC}

\item{sd.gamma}{standard deviation for the proposed \code{gamma} in the MCMC}

\item{sd.sigma}{standard deviation for the proposed \code{sigma} in the MCMC}

\item{p1}{probability that the MCMC will propose a new \code{(gamma,sigma)}; 
\code{(1-p1)} would be the probability that the MCMC chain will propose a 
new index for a new threshold}

\item{p2}{probability that the new index proposed will be larger than the 
current index}

\item{lambda1}{the small jump the index variable will make}

\item{lambda2}{the large jump the index variable will make; happens 1 of 
every 10 iterations}

\item{Jnumb}{number of subsamples that are taken from the Jacobian}

\item{iter}{number of iterations per chain (burnin excluded)}

\item{burnin}{number of the first MCMC iterations discarded}

\item{thin}{thinning number for the MCMC chain. (e.g. if it is 1 no iteration 
is skipped)}

\item{nchains}{number of MCMC chains to run}

\item{nthreads}{number of threads to run the chains in parallel}

\item{seeds}{the seeds used for the MCMC sampler; one seed per chain, or 
\code{NULL} to use random seeds}

\item{allParameters}{logical, whether to return the MCMC chains of all 
parameters (pretty useless) or only the ones of the quantiles}
}
\value{
An object of class \code{\link[coda:mcmc]{mcmc}} if \code{nchains=1}, 
  otherwise an object of class \code{\link[coda:mcmc.list]{mcmc.list}}.
}
\description{
Runs the MCMC sampler of the fiducial distribution for the 
  generalized Pareto model with unknown threshold.
}
\examples{
set.seed(31415L)
X <- rgamma(350L, shape = 10, rate = 1)
gf <- gfigpd2(X, beta = c(0.98, 0.99), iter = 3000L, nthreads = 2L)
summary(gf)
qgamma(c(0.98, 0.99), shape = 10, rate = 1)
traceplot(gf[,"beta1"])
traceplot(gf[,"beta2"])
thresholdEstimate(gf)
rejectionRate(gf)
HPDinterval(gf)
HPDinterval(joinMCMCchains(gf))
}
\references{
Damian V. Wandler & Jan Hannig. 
  \emph{Generalized fiducial confidence intervals for extremes}.
  Extremes (2012) 15:67–87.
  <doi:10.1007/s10687-011-0127-9>
}
