% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/article_bibextra.R
\name{article_bibextra}
\alias{article_bibextra}
\title{Preparer of main references for automatic insertion in scientific articles}
\usage{
article_bibextra(input_date, input_tam)
}
\arguments{
\item{input_date}{is a dataframe with the scientific production database obtained of colection WoS, Scopus and others}

\item{input_tam}{is the length of the dataframe with the main scientifics articles, obtained using package bibliorefer.}
}
\value{
This function returns a file with the .bib extension, containing the list of references in bibtex format, prepared to be automatically included in the reference list of a scientific paper.
}
\description{
The article_bibextra function prepares the metadata of the main scientific references to be automatically included in a scientific article. Initially, the user obtains the list of main references indicated and enters them into the standardized tabarticle_extra spreadsheet. The article_bibextra function internally calls the gerard_lister and bibtex_lister functions. The gerard_lister function separates and organizes the metadata of each article in the list selected by the user and stores it in a dataframe. The bibtex_lister function is then applied to the set of metadata organized in the dataframe and converts it to BibTex format. The output of the article_bibextra function is a file with the .bib extension, containing the list of references in BibTex format, prepared to be automatically included in the reference list of a scientific article.
}
\examples{

# Example 1

# File of database
file_db <- system.file("extdata","database_articleextra.csv", package = "gerefer")

input_date <- example_database2(file_db)
input_tam <- 8

#Calls the function article_bib
lister_bibtex <- article_bibextra(input_date, input_tam)
lister_bibtex

}
\references{
1 - Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier.
2 - Bibliometric indicators to evaluate scientific activity. C García-Villar, J M García-Santos. Radiologia (Engl Ed). 2021 May-Jun;63(3):228-235.
}
