#' Geosciences Reference Data Sets in R
#'
#' @description The package includes reference data sets commonly used in
#' geosciences, such as the standard atomic weights of elements, a periodic
#' table, a mineral list, reservoir reference datasets (continental crust,
#' mantle, basalts, etc.), decay constants, and isotopic ratios frequently used
#' in geochronology. Additionally, the package provides functions for basic
#' queries of atomic weights and mineral lists.\cr
#' All datasets have complete references, making them citable.
#'
#' @references { \insertNoCite{*}{georefdatar} \insertAllCited{} }
#' @importFrom Rdpack reprompt
#'
#' @author  Gerald Schuberth-Hlavač
#' @aliases georefdatar-package
#' @name    georefdatar_package
#' @rdname  georefdatar_package
NULL

globalVariables(c("ICS_Colors"))
