% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdq.R
\name{sdq}
\alias{sdq}
\title{Root Mean Square Slope of Surface}
\usage{
sdq(x)
}
\arguments{
\item{x}{A raster or matrix.}
}
\value{
A numeric value representing the two-point root
  mean square slope, Sdq. The units of the returned value
  are change in z per one unit (pixel).
}
\description{
Calculates the root mean square slope of a raster or matrix
surface using the two-point method.
}
\examples{
# import raster image
data(normforest)
normforest <- terra::unwrap(normforest)

# calculate root mean square slope
Sdq <- sdq(normforest)
}
\references{
This function is based
on the equations found at
https://www.ntmdt-si.ru/data/media/files/manuals/image_analisys_p9_nov12.e.pdf.
}
