% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{remove_plane}
\alias{remove_plane}
\title{Removes the Best Fit Polynomial Surface}
\usage{
remove_plane(x)
}
\arguments{
\item{x}{A raster or matrix.}
}
\value{
A raster or matrix of the same size as the input with values
  equal to the difference between the original and bestfit
  plane.
}
\description{
Finds the best fit polynomial surface for a raster or matrix and
subtracts it from the actual values. The output image has positive values
where the actual values are higher than the surface and negative values
where the actual value are lower than the surface.
}
\examples{
# import raster image
data(orforest)
orforest <- terra::unwrap(orforest)

# remove the least squares polynomial surface
new_rast <- remove_plane(orforest)

# plot
terra::plot(new_rast)
}
