\name{choose.compound}
\alias{choose.compound}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Choose a compound distribution.
}
\description{
choose.compound select a combination of baseline and compounding distributions in the class of compound distribution. 
See details for supported distributions.}
\usage{
choose.compound(x, type = "positive", criteria = "AIC")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
the vector of values to be fitted. 
}
  \item{type}{
Support of the x's. Avaliable options: positive (default), unit, real.
}
  \item{criteria}{
model selection criteria to be applied for the selection. Avaliable options: AIC (default, Akaike's information criteria)
and BIC (Bayesian's information criteria).
}
}
\details{
The compound distribution has cumulative distribution function
\deqn{
F(x;\gamma,\beta,\theta_1,\theta_2)=G_2(G_1(F(x;\gamma,\beta),\theta_1),\theta_2),
}
where \eqn{F} is related to the baseline distribution and \eqn{G_1, G_2} are related to compounding models.
For positive values, the options assessed for \eqn{F} are exponential, gamma, log-normal, paretoII and Birnbaum-Saunders.
For unit values, the options for \eqn{F} are beta and Kumaraswamy.
For real values, the options for \eqn{F} are normal, logistic, Cauchy and Gumbel.
For \eqn{G_1} and \eqn{G_2} are assessed all the combinations among the exponentiated, exponentiated of second kind,
Marshall-Olkin, Marshall-Olkin of the second kind and 
}
\value{
A list containing the following components:
\item{coefficients}{A matrix with the estimates and standard errors.}
\item{logLik}{The log-likelihood function evaluated in the estimated parameters}
\item{AIC}{Akaike's Information Criterion}
\item{BIC}{Bayesian's Information Criterion}
}
%\references{
%% ~put references to the literature/web site here ~
%}
\author{
Yolanda M. Gomez, Diego I. Gallardo, Hector W. Gomez and Barry Arnold
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}
\examples{
set.seed(2100)
y=rcompound(100, 1.2, 1.4, 1, 0.8, dist="exp", comp1="EXP", comp2="MO")
\donttest{
choose.compound(y, type="positive")
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
% \keyword{ ~kwd1 }
% \keyword{ ~kwd2 }
% Use only one keyword per line.
% For non-standard keywords, use \concept instead of \keyword:
% \concept{ ~cpt1 }
% \concept{ ~cpt2 }
% Use only one concept per line.
