\name{EXP}
\alias{dEXP}
\alias{pEXP}
\alias{qEXP}
\alias{rEXP}
\alias{dEXP2}
\alias{pEXP2}
\alias{qEXP2}
\alias{rEXP2}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
The Exponentiated and Exponentiated2 distributions
}
\description{
Density, distribution function, quantile function and random generation for the Exponentiated (EXP) and Exponentiated of the second kind (EXP2) distributions.
}
\usage{
dEXP(x, alpha = 1, log = FALSE)
pEXP(q, alpha = 1, lower.tail = TRUE, log.p = FALSE)
qEXP(p, alpha = 1, lower.tail = TRUE, log.p = FALSE)
rEXP(n, alpha = 1)
dEXP2(x, alpha = 1, log = FALSE)
pEXP2(q, alpha = 1, lower.tail = TRUE, log.p = FALSE)
qEXP2(p, alpha = 1, lower.tail = TRUE, log.p = FALSE)
rEXP2(n, alpha = 1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x, q}{
vector of quantiles.
}
  \item{p}{
vector of probabilities.
}
  \item{n}{
number of observations. If length(n) > 1, the length is taken to be the number required.
}
\item{alpha}{
shape parameter (by default is 1).
}
\item{log, log.p}{
logical; if TRUE, probabilities p are given as log(p).
}
\item{lower.tail}{
logical; if TRUE (default), probabilities are \eqn{P[X\leq x]}, otherwise \eqn{P[X>x]}. 
}
}
\details{
The EXP model has cumulative distribution function
\deqn{
F(x;\alpha)=x^\alpha, \quad x \in (0,1), \alpha>0,
}
whereas the EXP2 model has cumulative distribution function
\deqn{
F(x;\alpha)=1-(1-x)^\alpha, \quad x \in (0,1), \alpha>0,
}
}
\value{
dEXP and dEXP2 give the density, pEXP and pEXP2 give the distribution function, qEXP and qEXP2 give the quantile function, and rEXP and rEXP2 generate random deviates.
The length of the result is determined by n for rcompound, and is the maximum of the lengths of the numerical arguments for the other functions.
The numerical arguments other than n are recycled to the length of the result. Only the first elements of the logical arguments are used.
}
%\references{
%% ~put references to the literature/web site here ~
%}
\author{
Yolanda M. Gomez, Diego I. Gallardo, Hector W. Gomez and Barry Arnold
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}
\examples{
set.seed(2100)
y=rEXP(100, alpha = 1.2)
}

