% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabnew.r
\name{stab.fw.check}
\alias{stab.fw.check}
\title{Check-based yield stability analysis}
\usage{
stab.fw.check(y, Gen, Env, times, check, Rep, X = NULL, alpha = NULL)
}
\arguments{
\item{y}{A response varible vector used for stability analysis}

\item{Gen}{A vector of genotypes.}

\item{Env}{A vector of environments.}

\item{times}{Times of resampling used for stability analysis.}

\item{check}{One or more checks used for stability analysis.}

\item{Rep}{An argument with replication: Rep=TRUE or with replication: Rep=FALSE}

\item{X}{A vector or matrix of other predictable variables. Default is NULL.}

\item{alpha}{A nominal probability values used for statistical tests. Default is NULL, 0.05}
}
\value{
A list of yield stability results
}
\description{
Check-based yield stability analysis
}
\examples{
data(maize)
#names(maize)
Geno=as.vector(maize$Cultivar)
Env=paste(maize$Location,maize$Year,sep=":")
y=maize$Yld
res=stab.fw.check(y,Gen=Geno,Env=Env,times=10,check=c("Hai He"),Rep=FALSE)
res
}
\references{
Finlay, K.W., G.N. Wilkinson 1963. The analysis of adaptation in a plant breeding programme. Australian Journal of Agricultural Research 14: 742-754.

Wu, J., K. Glover, W. Berzonsky, 2012. Statistical tests for stability analysis with resampling techniques. 25th Conference of Applied Statistics in Agriculture. p88-108. April 29-May 01, 2012. Manhattan, KS

Wu, J., K. Glover, and N. Mueller 2014. Check based stability analysis method and its application to winter wheat variety trials," Conference on Applied Statistics in Agriculture. P102-114. https://doi.org/10.4148/2475-7772.1006
}
