% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prelec2.R
\name{prelec2}
\alias{prelec2}
\title{Intermediate weighting function giving Non-Expected Utility theory weights.}
\usage{
prelec2(n)
}
\arguments{
\item{n}{{A (usually small) integer.}}
}
\value{
\item{x}{sequence 1:n}
\item{p}{probabilities p= x[i]/n}
\item{pdif}{consecutive differences p[i] - p[i - 1]}
}
\description{
Computes cumulative probabilities and difference between consecutive
cumulative probabilities described in Vinod (2008) textbook.  This is a simpler version
of the version in the book without mapping to non-expected utility theory weights
as explained in Vinod (2008).
}
\examples{

 \dontrun{prelec2(10)}

}
\references{
Vinod, H. D. `Hands-On Intermediate Econometrics
Using R'  (2008) World Scientific Publishers: Hackensack, NJ.
\url{https://www.worldscientific.com/worldscibooks/10.1142/12831}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\concept{Prelec weights}
\concept{non expected utility function}
