% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova_varcomps.R
\name{anova_var_calcs}
\alias{anova_var_calcs}
\title{ANOVA Variance Component Calculations}
\usage{
anova_var_calcs(data, part, operator, meas)
}
\arguments{
\item{data}{An R dataframe or tibble.}

\item{part}{A column in data specifying the unique ID of the part being measured}

\item{operator}{A column in data specifying the operator for the recorded measurement}

\item{meas}{A column in data where the measurement value is recorded.}
}
\value{
A list of numeric values for repeatability, reproducibility, total GRR, part-to-part, and total variance components.
}
\description{
ANOVA Variance Component Calculations
}
\examples{
data = data.frame(
SN = c(
'SerialNumber_01',
'SerialNumber_01',
'SerialNumber_02',
'SerialNumber_02',
'SerialNumber_01',
'SerialNumber_01',
'SerialNumber_02',
'SerialNumber_02'),

Operator = c(
'Operator_01',
'Operator_01',
'Operator_01',
'Operator_01',
'Operator_02',
'Operator_02',
'Operator_02',
'Operator_02'),

Measure = c(
0.0172,
0.0177,
0.0155,
0.0159,
0.0174,
0.0181,
0.0152,
0.0176))

anova_var_calcs(data, part = 'SN', operator = 'Operator', meas = 'Measure')
}
