% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtoolbar.R
\name{gtoolbar}
\alias{gtoolbar}
\alias{.gtoolbar}
\alias{add.GToolBar}
\alias{svalue<-.GToolBar}
\title{A toolbar constructor}
\usage{
gtoolbar(
  toolbar.list = list(),
  style = c("both", "icons", "text", "both-horiz"),
  container = NULL,
  ...,
  toolkit = guiToolkit()
)

.gtoolbar(
  toolkit,
  toolbar.list = list(),
  style = c("both", "icons", "text", "both-horiz"),
  container = NULL,
  ...
)

\method{add}{GToolBar}(obj, child, expand = FALSE, fill = NULL, anchor = NULL, ...)

\method{svalue}{GToolBar} (obj, index=NULL, ...) <- value
}
\arguments{
\item{toolbar.list}{list. A one-level list of \code{gaction}
items, \code{gseparator} items or possibly other widgets. In the
latter cases the \code{container} argument is not specified
prior. (XXX Need to work this out with gWidgetstcltk)}

\item{style}{style for icon or text.}

\item{container}{a GWindow instance}

\item{...}{ignored}

\item{toolkit}{toolkit}

\item{obj}{parent object}

\item{child}{child widget}

\item{expand}{NULL or logical. For box containers controls whether a child will expand to fill the allocated space.}

\item{fill}{NULL or character. For box containers. The value of \code{fill} (not
always respected) is used to control if expansion happens
vertically (\code{y}), horizontally (\code{x}) or both
(\code{both} or \code{TRUE}). For vertically filled box
containers, children always fill horizontally (atleast) and for
horizontally filled box containers, children always fill
vertically (atleast). This is important to realize when trying to
size buttons, say.}

\item{anchor}{NULL or integer. For box containers. The anchor argument is used to
position the child within the parent when there is more space
allocated than the child requests. This is specified with a
Cartesian pair in \{-1,0,1\} x \{-1, 0, 1\}.}

\item{index}{NULL or logical. If \code{TRUE} and widget supports it an index, instead of a value will be returned.}

\item{value}{value to assign for selection or property}
}
\description{
A toolbar can be added to a main window to proxy various
actions. Toolbars can also contain various widgets, such as
buttons, checkboxes, radio buttons, etc. These should be
constructed using a \code{parent} argument -- not a
\code{container} argument. In \pkg{gWidgets2} a toolbar is
specified by a list of toolbar items. The \code{svalue} and
\code{svalue<-} methods may be used to get or set the items.

A toolbar item is a list of action items or a toolbar instance

for a toolbar, \code{svalue<-} replaces the toolbar items with new ones specified by value.
}
