% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OPF_7bit_T1.R
\name{OPF_7bit_T1}
\alias{OPF_7bit_T1}
\title{Overlapping property features_7bit_T1 (OPF_7bit_T1)}
\usage{
OPF_7bit_T1(seqs, label = c(), outFormat = "mat", outputFileDist = "")
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}

\item{outFormat}{(output format) can take two values: 'mat'(matrix) and 'txt'. The default value is 'mat'.}

\item{outputFileDist}{shows the path and name of the 'txt' output file.}
}
\value{
The output is different depending on the outFormat parameter ('mat' or 'txt').
If outFormat is set to 'mat', it returns a feature matrix for sequences with the same lengths.
Number of columns for this feature matrix is equal to (length of the sequences)*7 and number of rows is equal to the number of sequences.
If outFormat is 'txt', all binary values will be written to a the output is written to a tab-delimited file. Each line in the file shows the binary format of a sequence.
}
\description{
This group of functions (OPF Group) categorize amino acids in different groups based on the type.
This function includes 7 amino acid properties. OPF_7bit_T1 substitutes each amino acid with a 7-dimensional vector.
Each element of the vector shows if that amino acid locates in a special property category or not. '0' means that amino acid is not located in that property group and '1' means it is located.
The only difference between OPF_7bit type1, type2, and type3 is in localization of amino acids in the properties groups.
}
\note{
This function is provided for sequences with the same lengths.
Users can use 'txt' option in outFormat for sequences with different lengths.
Warning: If outFormat is set to 'mat' for sequences with different lengths, it returns an error.
Also, when output format is 'txt', label information is not shown in the text file.
It is noteworthy that 'txt' format is not usable for machine learning purposes if sequences have different sizes. Otherwise 'txt' format
is also usable for machine learning purposes.
}
\examples{

ptmSeqsADR<-system.file("extdata/",package="ftrCOOL")
ptmSeqsVect<-as.vector(read.csv(paste0(ptmSeqsADR,"/ptmVect101AA.csv"))[,2])
mat<-OPF_7bit_T1(seqs = ptmSeqsVect,outFormat="mat")

}
\references{
Wei,L., Zhou,C., Chen,H., Song,J. and Su,R. ACPred-FL: a sequence-based predictor using effective feature representation to improve the prediction of anti-cancer peptides. Bioinformatics (2018).
}
